* bark_beetle_experiment.sas;
title "One-way ANOVA for bark beetle trapping experiment";
data bark_beetle;
	input treat $ count;
	* Apply transformations here;
	y = log10(count);
	datalines; 
A   373
A   126
A   255
A   138
A   379
B    25
B    64
B    62
B    71
B    54
C   449
C   249
C    69
C   199
C    84
;
run;
* Print data set;
proc print data=bark_beetle;
run;
* Plot means, standard errors, and observations;
proc gplot data=bark_beetle;
	plot y*treat=1 / vaxis=axis1 haxis=axis1;
	symbol1 i=std1mjt v=star height=2 width=3;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
run;
* One-way ANOVA with all fixed effects;
proc glm plots=diagnostics data=bark_beetle;
	class treat;
	model y = treat;
	* Calculate means for each group;
	means treat;
run;
quit;
